/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.lux;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.PlayerCreatureEntity;
import entities.creatures.enemies.LuxEntity;
import entities.missiles.MissileEntity;
import util.Config;
import util.ResourceManager;

public final class LuxAbilityREntity
extends MissileEntity {
    private boolean init = true;
    private boolean used = false;

    public LuxAbilityREntity(LuxEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/lux/abilityR_init", x, y);
        this.removeWhenOutOfArea = false;
        this.dy = 0.0;
        this.dx = 0.0;
    }

    public void BlastIsOver() {
        this.game.removeEntity(this);
    }

    public void initIsOver() {
        this.init = false;
        this.sprite = ResourceManager.get().getSprite("missiles/lux/abilityR");
    }

    public boolean isInitOver() {
        return !this.init;
    }

    @Override
    protected void calculateHitbox() {
        this.hitbox.setBounds((int)this.x + 50, (int)this.y, this.getW() - 50, this.getH());
    }

    @Override
    public void collidedWith(Entity other) {
        if (this.isInitOver() && !this.used && other instanceof PlayerCreatureEntity) {
            if (((CreatureEntity)other).hasEffectType("spellshield")) {
                ((CreatureEntity)other).removeEffectByType("spellshield");
            } else {
                ((CreatureEntity)other).damage(this, Config.get(Config.luxAbilityRDamage));
                ((CreatureEntity)other).addEffect("passiveLux", this.game.getTime() + (long)Config.get(Config.luxPassiveDuration));
            }
            this.used = true;
        }
    }
}

